<?php

use App\Http\Controllers\FrontController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Main\MainController;
use App\Http\Controllers\Main\NewsController;
use App\Models\User;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Laravel\Socialite\Facades\Socialite;

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    Artisan::call('config:cache');
    
    return 'Config cleared successfully';
})->name('clear.cache');

Route::get('/', [FrontController::class, 'home'])->name('front.home');
Route::get('/registers', [FrontController::class, 'register'])->name('front.register');
Route::get('/service', [FrontController::class, 'service'])->name('front.service');
Route::get('/term-of-service', [FrontController::class, 'terms'])->name('front.terms');
Route::get('/contact-us', [FrontController::class, 'contact_us'])->name('front.contact_us');
// NEWS
Route::get('/berita', [FrontController::class, 'newsIndex'])->name('front.news');
Route::get('/berita/{slug}', [FrontController::class, 'newsShow'])->name('front.news.show');

Route::get('auth/google', function () {
    return Socialite::driver('google')->redirect();
});

Route::get('auth/google/callback', function () {
    $googleUser = Socialite::driver('google')->user();

    // Cek apakah user sudah ada di database
    $user = User::where('email', $googleUser->getEmail())->first();

    if (!$user) {
        // Jika user belum ada, buat user baru
        $user = User::create([
            'name' => $googleUser->getName(),
            'email' => $googleUser->getEmail(),
            'google_id' => $googleUser->getId(),
            'password' => bcrypt('password_default'), // Opsional, karena Google tidak mengirimkan password
        ]);
    }

    // Login user
    Auth::login($user);

    return redirect()->route('main.dashboard');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

// ROUTE GROUP FOR AUTH USER
Route::group(['middleware' => ['auth']], function () {
    Route::get('/dashboard', [MainController::class, 'dashboard'])->name('main.dashboard');
    Route::post('/order', [MainController::class, 'order'])->name('main.order');
    Route::post('/webhook', [MainController::class, 'webhook'])->name('main.webhook');
    Route::get('/history-order', [MainController::class, 'historyOrder'])->name('main.history-order');
    Route::get('/history-order-data', [MainController::class, 'historyOrderData'])->name('main.history-order.data');
    Route::get('/order-guide', [MainController::class, 'orderGuide'])->name('main.order-guide');
    Route::get('/tickets', [MainController::class, 'tickets'])->name('main.tickets');
    Route::get('/terms', [MainController::class, 'terms'])->name('main.terms');
    Route::get('/contact-me', [MainController::class, 'contactMe'])->name('main.contact-me');
    Route::get('/account', [MainController::class, 'todoAccount'])->name('main.todoAccount');
    Route::put('/account', [MainController::class, 'account'])->name('main.account');

    Route::get('news/data', [NewsController::class, 'getData'])->name('news.data');
    Route::resource('news', NewsController::class);
});