@extends('layouts.app')

@section('title', 'Riwayat Pesanan')

@section('content')
<div id="block_52">
    <div class="block-bg"></div>
    <div class="container-fluid">
        <div class="orders-history ">
            <div class="row">
                <div class="col">
                    <div class="orders-history__margin-table">
                        <div class="table-bg component_table ">
                            <div class="table-wr ">
                                <table class="table" id="data-table">
                                    <thead>
                                        <tr>
                                            <th colspan="10">
                                                <div
                                                    class="orders-history__margin-search orders-history__header-search">
                                                    <div class="component_form_group component_button_search">
                                                        <div class="">
                                                            <form action="/orders" method="get" id="history-search">
                                                                <div class="input-group">
                                                                    <input type="text" name="search"
                                                                        class="form-control" value=""
                                                                        placeholder="Pencarian">
                                                                    <div class="input-group-append">
                                                                        <button class="btn btn-big-secondary"
                                                                            type="submit">
                                                                            <span class="fas fa-search"></span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th>ID</th>
                                            <th>Tanggal</th>
                                            <th>Link</th>
                                            <th>Biaya</th>
                                            <th class="nowrap">Start count</th>
                                            <th>Jumlah</th>
                                            <th>Layanan</th>
                                            <th>Status</th>
                                            <th>Remains</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    $(document).ready(function() {
        init_table();
    
        // $(document).on('input', '#searchData', function() {
        //     init_table($(this).val());
        // })
    });

    function init_table(keyword = '') {
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            destroy: true,
            columnDefs: [{
                target: 0,
                visible: true,
                searchable: false
            }, ],

            ajax: {
                type: "GET",
                url: "{{ secure_url(route('main.history-order.data', [], false)) }}",
                data: {
                    'keyword': keyword
                },
            },
            columns: [
                {data: 'order_id', name: 'order_id'},
                {data: 'created_at', name: 'created_at'},
                {data: 'link', name: 'link'},
                {data: 'charge', name: 'charge'},
                {data: 'start_count', name: 'start_count'},
                {data: 'quantity', name: 'quantity'},
                {data: 'layanan', name: 'layanan'},
                {data: 'status', name: 'status'},
                {data: 'remains', name: 'remains'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
        });
    }
</script>

<script src="https://app.sandbox.midtrans.com/snap/snap.js"
    data-client-key="{{ config('services.midtrans.client_key') }}"></script>
<script>
    function payment(snap_token) {
        if (snap_token) {
            snap.pay(snap_token, {
                            onSuccess: function(result) {
                                var token = '{{ csrf_token() }}';
                                result['_token'] = token;

                                $.ajax({
                                    url: '{{ route("main.webhook") }}',
                                    type: 'POST',
                                    data: result,
                                    dataType: 'json',
                                })
                                .done(function(data) {
                                    location.reload();
                                })
                                .fail(function() {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Oops...',
                                        text: 'Something went wrong!',
                                    });
                                });
                            },
                            onPending: function(result) {
                                Swal.fire({
                                    icon: 'info',
                                    title: 'Pembayaran Pending',
                                    text: 'Silakan selesaikan pembayaran Anda',
                                });
                            },
                            onError: function(result) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Pembayaran Gagal',
                                    text: 'Silakan coba lagi atau hubungi admin',
                                });
                            }
                        });
            }
        }
</script>
@endpush