@extends('layouts.front')

@section('title', 'List Harga')

@section('content')
<div id="block_54">
    <div class="block-bg">
        <div class="bg-image"></div>
    </div>
    <div class="container">
        <meta name="viewport" content="width=991, initial-scale=0">
        <div class="services-list ">
            <div class="row">
                <div class="col">
                    <div class="services-list__table">
                        <div class="table-bg component_table ">
                            <div class="table-wr table-responsive editor__component-wrapper">
                                <table class="table" id="service-table-54">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th class="nowrap">Layanan</th>
                                            <th class="nowrap">Rate</th>
                                            <th class="nowrap">Min order</th>
                                            <th class="nowrap">Max order</th>
                                        </tr>
                                    </thead>
                                    <tbody id="service-tbody">
                                        @foreach ($categoryProduct as $item)
                                            <tr class="services-list-category-title"
                                                data-filter-table-category-id="5">
                                                <td colspan="5"
                                                    class="style-bg-primary-alpha-20 style-text-primary services-category editor__component-wrapper">
                                                    <div class="w-100 ">
                                                        <h4>
                                                            <img src="{{ asset($item->icon) }}"
                                                                alt="{{  $item->name }}"
                                                                class="img-fluid align-middle mr-1"
                                                                style="max-width: calc(1em + 6px); max-height: calc(1em + 6px);">
                                                            <span class="align-middle">{{ $item->name }}</span>
                                                        </h4>
                                                    </div>
                                                </td>
                                            </tr>

                                            @foreach (collect($item->product)->where('status', 1) as $value)
                                                <tr>
                                                    <td>{{ $value->id }}</td>
                                                    <td class="nowrap">
                                                        <div class="d-flex align-items-center">
                                                            <img src="{{ $value->icon }}"
                                                                alt="{{  $value->name }}"
                                                                class="img-fluid align-middle mr-1"
                                                                style="max-width: calc(1em + 6px); max-height: calc(1em + 6px);">
                                                            <span class="align-middle">{{ $value->name }}</span>
                                                        </div>
                                                    </td>
                                                    <td class="nowrap">
                                                        <div class="d-flex align-items-center">
                                                            <span class="align-middle">Rp
                                                                {{ number_format($value->rate, 0, ',', '.') }}</span>
                                                        </div>
                                                    </td>
                                                    <td class="nowrap">
                                                        <div class="d-flex align-items-center">
                                                            <span class="align-middle">{{ $value->min }}</span>
                                                        </div>
                                                    </td>
                                                    <td class="nowrap">
                                                        <div class="d-flex align-items-center">
                                                            <span class="align-middle">{{ $value->max }}</span>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade " tabindex="-1" role="dialog" id="service-description-54">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                            <i class="fas fa-times"></i>
                        </button>
                        <div class="service-description-content"></div>
                        <button class="btn btn-block btn-big-primary" id="createQuickOrder"
                            style="margin-top: 24px;">
                            Pesan Layanan Ini
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection