@extends('layouts.front')

@section('title', $news->meta_title ?? $news->title)

@section('meta_description', $news->meta_description ?? \Illuminate\Support\Str::limit(strip_tags($news->content), 150))

@section('meta_keywords', $news->meta_keywords)

@section('content')
<div class="container py-5" id="news-detail">
    <div class="row justify-content-center">
        <div class="col-md-10">

            <h1 class="mb-3">{{ $news->title }}</h1>

            @if($news->published_at)
                <p class="text-muted mb-4">
                    Published on {{ \Carbon\Carbon::parse($news->published_at)->format('F j, Y') }}
                </p>
            @endif

            @if($news->featured_image)
                <div class="mb-4">
                    <img src="{{ asset('storage/' . $news->featured_image) }}" class="img-fluid rounded" alt="{{ $news->title }}">
                </div>
            @endif

            <div class="news-content mb-5">
                {!! $news->content !!}
            </div>

            <div>
                <a href="{{ route('front.news') }}" class="btn btn-big-primary">← Back to News</a>
            </div>
        </div>
    </div>
</div>
@endsection
