@extends('layouts.front')

@section('title', 'News')

@section('content')
<div id="news-list" class="container">
    <h1 class="text-center">Latest News</h1>

    <div class="row">
        @foreach($news as $item)
            <div class="col-12 col-md-6 col-lg-4 mb-4">
                <a href="{{ route('front.news.show', $item->slug) }}">
                    <div class="card">
                        <img src="{{ asset('storage/' . $item->featured_image) }}" class="card-img-top" alt="{{ $item->title }}">
                        <div class="card-body">
                            <small>{{ \Carbon\Carbon::parse($item->created_at)->format('F d, Y') }}</small>
                            <h5 class="card-title">{{ $item->title }}</h5>
                            <p class="card-text">{{ \Illuminate\Support\Str::limit($item->content, 100) }}</p>
                        </div>
                    </div>
                </a>
            </div>
        @endforeach
    </div>
</div>
@endsection
