<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\Service;
use App\SmmPanelIndoTrait;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Log;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    use SmmPanelIndoTrait;

    public function run(): void
    {
        $service = $this->service();

        foreach ($service as $key => $value) {
            $value['service_id'] = $value['service'];
            unset($value['service']);
            $createService = Service::create($value);

            $product = [
                'category_product_id' => 1,
                'icon' => null,
                'name' => $value['name'],
                'status' => 0,
                'service_id' => $createService->service_id,
                'type' => $value['type'],
                'rate' => $value['rate'],
                'min' => $value['min'],
                'max' => $value['max'],
                'dripfeed' => $value['dripfeed'],
                'refill' => $value['refill'],
                'cancel' => $value['cancel'],
            ];
    
            $createProduct = Product::create($product);
        }
    }
}
