<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_product_id')->index();
            $table->string('icon')->nullable();
            $table->string('name');
            $table->text('description')->nullable();
            $table->boolean('status')->default(1)->comment('1: active, 0: inactive');
            // IN API SMMPANEL INDO
            $table->unsignedBigInteger('service_id')->index();
            $table->string('type')->default('Default');
            $table->decimal('rate', 10, 2)->default(0);
            $table->integer('min')->default(0);
            $table->integer('max')->default(0);
            $table->boolean('dripfeed')->default(0);
            $table->boolean('refill')->default(0);
            $table->boolean('cancel')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
