<?php

namespace App;

use Illuminate\Support\Facades\Http;

trait SmmPanelIndoTrait
{
    private $base_url = 'https://indosmm.id/api/v2';
    private $api_key = 'b3d95ded137dc3f13cf6144e93f1583e';

    public function orderStatus($order_id)
    {
        $response = Http::post($this->base_url, [
            'key' => $this->api_key,
            'action' => 'status',
            'order' => $order_id,
        ]);

        return $response->json();
    }

    public function service()
    {
        $response = Http::post($this->base_url, [
            'key' => $this->api_key,
            'action' => 'services',
        ]);

        return $response->json();
    }

    public function createOrder($service_id, $link, $quantity)
    {
        $response = Http::post($this->base_url, [
            'key' => $this->api_key,
            'action' => 'add',
            'service' => $service_id,
            'link' => $link,
            'quantity' => $quantity,
        ]);

        return $response->json();
    }

    public function balance()
    {
        $response = Http::post($this->base_url, [
            'key' => $this->api_key,
            'action' => 'balance',
        ]);

        return $response->json();
    }
}
