

<?php $__env->startSection('title', $news->meta_title ?? $news->title); ?>

<?php $__env->startSection('meta_description', $news->meta_description ?? \Illuminate\Support\Str::limit(strip_tags($news->content), 150)); ?>

<?php $__env->startSection('meta_keywords', $news->meta_keywords); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5" id="news-detail">
    <div class="row justify-content-center">
        <div class="col-md-10">

            <h1 class="mb-3"><?php echo e($news->title); ?></h1>

            <?php if($news->published_at): ?>
                <p class="text-muted mb-4">
                    Published on <?php echo e(\Carbon\Carbon::parse($news->published_at)->format('F j, Y')); ?>

                </p>
            <?php endif; ?>

            <?php if($news->featured_image): ?>
                <div class="mb-4">
                    <img src="<?php echo e(asset('storage/' . $news->featured_image)); ?>" class="img-fluid rounded" alt="<?php echo e($news->title); ?>">
                </div>
            <?php endif; ?>

            <div class="news-content mb-5">
                <?php echo $news->content; ?>

            </div>

            <div>
                <a href="<?php echo e(route('front.news')); ?>" class="btn btn-big-primary">← Back to News</a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\ADI\Herd\dan_store\resources\views/front/news/show.blade.php ENDPATH**/ ?>