@extends('layouts.app')

@section('title', 'Manajemen Berita')

@section('content')
<div id="block_52">
    <div class="block-bg"></div>
    <div class="container-fluid">
        <div class="orders-history">
            <div class="row">
                <div class="col">
                    <div class="orders-history__margin-table">
                        <div class="table-bg component_table">
                            <div class="table-wr">
                                <div class="mb-3">
                                    <a href="{{ route('news.create') }}" class="btn btn-big-primary">
                                        <i class="fas fa-plus"></i> Tambah Berita
                                    </a>
                                </div>

                                <table class="table" id="data-table">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Judul</th>
                                            <th>Slug</th>
                                            <th>Tanggal Publikasi</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     </div>
</div>
@endsection

@push('js')
<script>
    $(document).ready(function() {
        $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ secure_url(route('news.data', [], false)) }}",
            columns: [
                { data: 'id', name: 'id' },
                { data: 'title', name: 'title' },
                { data: 'slug', name: 'slug' },
                { data: 'published_at', name: 'published_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });
    });
</script>
@endpush
