@extends('layouts.app')

@section('title', 'Tambah Berita')

@section('content')
<div id="block_52">
    <div class="block-bg"></div>
    <div class="container-fluid">
        <div class="orders-history">
            <div class="row">
                <div class="col">
                    <div class='card'>
                        <div class='card-header'>
                            Buat Berita Baru
                        </div>
                        <div class='card-body'>
                            <div class="orders-history__margin-table">
                                <div class="table-bg component_table">
                                    <div class="table-wr">
                                        <form action="{{ route('news.store') }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label for="title">Judul</label>
                                                <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="slug">Slug</label>
                                                <input type="text" name="slug" class="form-control" value="{{ old('slug') }}" required>
                                            </div>
                                            <div class="form-group">
                                                <label for="excerpt">Ringkasan</label>
                                                <textarea name="excerpt" class="form-control" rows="3">{{ old('excerpt') }}</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="content">Konten</label>
                                                <textarea name="content" class="form-control" rows="6">{{ old('content') }}</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="published_at">Tanggal Publikasi</label>
                                                <input type="datetime-local" name="published_at" class="form-control" value="{{ old('published_at') }}">
                                            </div>
                                            <div class="form-group">
                                                <label for="featured_image">Gambar Unggulan</label>
                                                <input type="file" name="featured_image" class="form-control-file">
                                            </div>
                                            <div class="form-group">
                                                <label for="meta_title">Meta Title</label>
                                                <input type="text" name="meta_title" class="form-control" value="{{ old('meta_title') }}">
                                            </div>
                                            <div class="form-group">
                                                <label for="meta_description">Meta Description</label>
                                                <textarea name="meta_description" class="form-control" rows="2">{{ old('meta_description') }}</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="meta_keywords">Meta Keywords</label>
                                                <input type="text" name="meta_keywords" class="form-control" value="{{ old('meta_keywords') }}">
                                            </div>
                                            <button type="submit" class="btn btn-primary mt-3">Simpan</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
     </div>
</div>
@endsection
