<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('news', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // Judul berita
            $table->string('slug')->unique(); // URL slug untuk SEO
            $table->text('excerpt')->nullable(); // Ringkasan berita
            $table->longText('content'); // Konten lengkap berita
            $table->string('meta_title')->nullable(); // Meta title untuk SEO
            $table->text('meta_description')->nullable(); // Meta description untuk SEO
            $table->string('meta_keywords')->nullable(); // Meta keywords untuk SEO
            $table->string('featured_image')->nullable(); // URL gambar unggulan
            $table->timestamp('published_at')->nullable(); // Tanggal publikasi
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('news');
    }
};
