<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->unsignedBigInteger('category_product_id')->index();
            $table->unsignedBigInteger('product_id')->index();
            $table->unsignedBigInteger('service_id')->index();
            $table->unsignedBigInteger('order_id')->index()->nullable();
            $table->string('order_id_midtrans')->nullable();
            $table->string('link');
            $table->integer('quantity')->default(0);
            $table->decimal('charge', 10, 2);
            $table->integer('remains')->default(0);
            $table->string('currency')->default('IDR');
            $table->integer('start_count')->default(0);
            $table->enum('status', ['Need Payment', 'Pending', 'In progress', 'Partial', 'Completed', 'Canceled', 'Expired'])->default('Need Payment');
            $table->string('file_payment')->nullable();
            $table->string('snap_token')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
