<?php

namespace App\Http\Controllers;

use App\Models\CategoryProduct;
use App\Models\News;
use Illuminate\Http\Request;

class FrontController extends Controller
{
    public function home()
    {
        return view('front.home');
    }

    public function register()
    {
        return view('front.register');
    }

    public function service()
    {
        $categoryProduct = CategoryProduct::all();
        
        return view('front.service', compact('categoryProduct'));
    }

    public function terms()
    {
        return view('front.terms');
    }

    public function contact_us()
    {
        return view('front.contact_us');
    }

    public function newsIndex()
    {
        $news = News::orderBy('created_at', 'desc')->get();

        return view('front.news.index', compact('news'));
    }

    public function newsShow($slug)
    {
        $news = News::where('slug', $slug)->firstOrFail();
        
        return view('front.news.show', compact('news'));
    }
}
